#ifndef CYPRESS_CONFTEST_H_
#define CYPRESS_CONFTEST_H_

/* Configuration/Test Mode Registers */
//HST_MODE        -> defined in system_information.h
//RESET_DETECT    -> defined in system_information.h
#define CONFIGURATION_COMMAND                                   0x02
#define CONFIGURATION_COMMAND_DATA                              0x03

/* Configuration/Test Mode commands */
#define CYPRESS_CONFIG_PING                                     0x00
#define CYPRESS_CONFIG_GET_ROW_SIZE                             0x02
#define CYPRESS_CONFIG_GET_ROW_SIZE_LEN                         2

#define CYPRESS_CONFIG_READ_DATA_BLOCK                          0x03
#define CYPRESS_CONFIG_WRITE_DATA_BLOCK                         0x04

#define CYPRESS_CONFIG_LOAD_SELF_TEST_DATA                      0x06
#define CYPRESS_CONFIG_RUN_SELF_TEST                            0x07
#define CYPRESS_CONFIG_SELF_TEST_COMMAND_LEN                    1

/* CYTAT81X Family Only */
#define CYPRESS_CONFIG_CM_PANEL_TEST                            0x05
#define CYPRESS_CONFIG_CM_PANEL_TEST_REPLY_LEN                  3
#define CYPRESS_CONFIG_CP_PANEL_TEST                            0x06
#define CYPRESS_CONFIG_CP_PANEL_TEST_REPLY_LEN                  3
#define CYPRESS_CONFIG_GET_SELF_TEST_RESULTS                    0x08
#define CYPRESS_CONFIG_CALIBRATE_IDACS                          0x09
#define CYPRESS_CONFIG_CALIBRATE_IDACS_REPLY_LEN                1
#define CYPRESS_RETRIEVE_DATA_STRUCTURE                         0x10
#define CYPRESS_CONFIG_INITALIZE_BASELINES                      0x0A
#define CYPRESS_CONFIG_INITALIZE_BASELINES_REPLY_LEN               1
#define CYPRESS_CONFIG_EXECUTE_PANEL_SCAN                       0x0B
#define CYPRESS_CONFIG_RETRIEVE_PANEL_SCAN                      0x0C
#define CYPRESS_CONFIG_START_SENSOR_DATA_MODE                   0x0D
#define CYPRESS_CONFIG_STOP_SENSOR_DATA_MODE                    0x0E
#define CYPRESS_CONFIG_INTERRUPT_PIN_OVERRIDE                   0x0F
#define CYPRESS_CONFIG_RETRIEVE_DATA_STRUCTURE                  0x10

/* Gen 4 */
#define CYPRESS_CONFIG_GEN4_RETRIEVE_DATA_REPLY_HEADER_SIZE     6
#define CYPRESS_CONFIG_GEN4_RETRIEVE_DATA_REPLY_STATUS          0
#define CYPRESS_CONFIG_GEN4_RETRIEVE_DATA_REPLY_DATA_ID         1
#define CYPRESS_CONFIG_GEN4_RETRIEVE_DATA_REPLY_SIZE            2  /* Two Bytes */
//#define CYPRESS_CONFIG_GEN4_RETRIEVE_DATA_REPLY_MTRX          2
#define CYPRESS_CONFIG_RETRIEVE_DATA_MTRX_MASK                  0x08

/* Gen 4 Data ID */
#define CYPRESS_CONFIG_GEN4_MUTUAL_PWC_DATA_CENTER_FREQUENCY    0x00
#define CYPRESS_CONFIG_GEN4_SELF_CAP_PWC_DATA                   0x01
/* Reserved                                                     0x02 */
#define CYPRESS_CONFIG_GEN4_BUTTON_PWC_DATA_MUTUAL_SCAN_CFG     0x03
#define CYPRESS_CONFIG_GEN4_BUTTON_PWC_DATA_SELF_SCAN_CFG       0x03
#define CYPRESS_CONFIG_GEN4_BUTTON_PWC_DATA_HYBRID_SCAN_CFG     0x03
#define CYPRESS_CONFIG_GEN4_MUTUAL_PWC_DATA_ALT1                0x04
#define CYPRESS_CONFIG_GEN4_MUTUAL_PWC_DATA_ALT2                0x05
#define CYPRESS_CONFIG_GEN4_TOUCH_REPORT                        0x06
/* Reserved                                                     0x07 - 0x1F */

/* Gen 6 */
#define CYPRESS_CONFIG_GEN6_RETRIEVE_DATA_REPLY_HEADER_SIZE     5
#define CYPRESS_CONFIG_GEN6_RETRIEVE_DATA_REPLY_STATUS          0
#define CYPRESS_CONFIG_RETRIEVE_DATA_REPLY_STATUS_SUCCESS       0
#define CYPRESS_CONFIG_GEN6_RETRIEVE_DATA_REPLY_DATA_ID         1
#define CYPRESS_CONFIG_GEN6_RETRIEVE_DATA_REPLY_SIZE            2
#define CYPRESS_CONFIG_GEN6_RETRIEVE_DATA_REPLY_MTRX            4

/* Gen 6 Data ID */
#define CYPRESS_CONFIG_GEN6_IDAC_RX_DATA_ID_FREQUENCY_CENTER    0x00
#define CYPRESS_CONFIG_GEN6_IDAC_RX_DATA_ID_FREQUENCY_ONE       0x04
#define CYPRESS_CONFIG_GEN6_IDAC_RX_DATA_ID_FREQUENCY_TWO       0x05
#define CYPRESS_CONFIG_GEN6_IDAC_RX_DATA_ID_FREQUENCY_THREE     0x07
#define CYPRESS_CONFIG_GEN6_IDAC_RX_DATA_ID_FREQUENCY_FIVE      0x09
#define CYPRESS_CONFIG_GEN6_RX_ATTENUATOR_MUTUAL                0
#define CYPRESS_CONFIG_GEN6_IDAC_MUTUAL                         1
#define CYPRESS_CONFIG_GEN6_RX_ATTENUATOR_SELF_RX               2
#define CYPRESS_CONFIG_GEN6_IDAC_SELF_RX                        3
#define CYPRESS_CONFIG_GEN6_RX_ATTENUATOR_SELF_TX               4
#define CYPRESS_CONFIG_GEN6_IDAC_SELF_TX                        5
#define CYPRESS_CONFIG_GEN6_RX_ATTENUATOR_BUTTON_MUTUAL         6
#define CYPRESS_CONFIG_GEN6_IDAC_BUTTON_MUTUAL                  7
#define CYPRESS_CONFIG_GEN6_RX_ATTENUATOR_BUTTON_SELF           8
#define CYPRESS_CONFIG_GEN6_IDAC_BUTTON_SELF                    9
#define CYPRESS_CONFIG_GEN6_MUTUAL_GAIN_CORRECTION              0x10
#define CYPRESS_CONFIG_GEN6_SELF_GAIN_CORRECTION                0x11
#define CYPRESS_CONFIG_GEN6_ATTENUATOR_TRIM                     0x12
#define CYPRESS_CONFIG_GEN6_PIN_INDEX_TABLE                     0x13

#define CYPRESS_CONFIG_VERIFY_DATA_BLOCK_CRC                    0x11
#define CYPRESS_CONFIG_CLEAR_ERRORS                             0x20
#define CYPRESS_CONFIG_CLEAR_ERRORS_REPLY_LEN                   1
#define CYPRESS_CONFIG_SET_HAPTIC_DATA                          0x26
#define CYPRESS_CONFIG_SET_HAPTIC_DATA_REPLY_LEN                   1

#define COMMAND_COMPLETE                                        (1 << 6)
#define CONTROLLER_COMPLETED_COMMAND                            (1 << 7) // 'Toggle' in the docs

#define CYPRESS_MODE_SWITCH_TIMEOUT_NANOSEC                     200000000

#endif /* CYPRESS_CONFTEST_H_ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/configuration_test.h $ $Rev: 886397 $")
#endif
